package ru.yandex.intranet.d.services.transfer;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.intranet.d.model.transfers.TransferRequestModel;

import static ru.yandex.intranet.d.util.UtmUtilsKt.addEmailUtmParams;

/**
 * Service for formatting text for transferRequest
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Component
public class TextFormatterService {

    private static final String STAFF_PREFIX_WIKI_FORMAT = "staff:";
    private final String frontUrl;
    private final String apiUrl;

    public TextFormatterService(@Value("${front.url}") String frontUrl,
                                @Value("${api.url}") String apiUrl) {
        this.frontUrl = frontUrl;
        this.apiUrl = apiUrl;
    }

    public String buildTransferUrl(String transferId) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(frontUrl)
                .pathSegment("folders", "transfers", transferId);
        addEmailUtmParams(builder);
        return builder.toUriString();
    }

    public String buildAllTransfersUrl() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(frontUrl)
                .pathSegment("approves", "quota-transfer");
        addEmailUtmParams(builder);
        return builder.toUriString();
    }

    public String buildTransferUrlWithName(TransferRequestModel transferRequest) {
        String url = UriComponentsBuilder.fromUriString(frontUrl)
                .pathSegment("folders", "transfers", transferRequest.getId()).toUriString();
        return buildLink(url, transferRequest.getSummary().orElse(transferRequest.getId()));
    }

    public String buildAbcLink(String abcServiceSlug) {
        return UriComponentsBuilder.fromUriString(frontUrl)
                .pathSegment("services", abcServiceSlug).toUriString();
    }

    public String buildOperationApiUrl(String operationId) {
        return UriComponentsBuilder.fromUriString(apiUrl)
                .pathSegment("api", "v1", "operations", operationId).toUriString();
    }

    public String buildStaffLink(String staffLogin) {
        return STAFF_PREFIX_WIKI_FORMAT + staffLogin;
    }

    public String buildLink(String url, String text) {
        return "((" + url + " " + text + "))";
    }

    public String buildBoldText(String text) {
        return "**" + text + "**";
    }
}
