package ru.yandex.intranet.d.services.transfer;

import java.util.Optional;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.model.users.UserModel;
import ru.yandex.intranet.d.services.notifications.MailNotification;
import ru.yandex.intranet.d.services.notifications.NotificationMailGenerator;
import ru.yandex.intranet.d.services.notifications.NotificationMailSender;

/**
 * TransferRequestNotificationsService.
 * Сервис для отправки нотификаций. Для вычисления кому отправлять их есть
 * {@link TransferRequestResponsibleAndNotifyService}.
 * Но, возможно, следует разделить в нём функционал и перенести вычисление всего что касается уведомлений сюда.
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 */
@Component
public class TransferRequestNotificationsService {
    private static final Logger LOG = LoggerFactory.getLogger(TransferRequestNotificationsService.class);

    private final NotificationMailGenerator mailGenerator;
    private final NotificationMailSender mailSender;

    public TransferRequestNotificationsService(NotificationMailGenerator mailGenerator,
                                               NotificationMailSender mailSender) {
        this.mailGenerator = mailGenerator;
        this.mailSender = mailSender;
    }

    public void sendNotifications(Set<UserModel> users, String transferRequestId) {
        try {
            users.forEach(user -> {
                try {
                    Optional<MailNotification> notification = mailGenerator
                            .generateTransferRequestNotification(transferRequestId, user);
                    notification.ifPresent(mailSender::sendBackground);
                } catch (Exception e) {
                    LOG.error("Failed to send notification to " + user, e);
                }
            });
        } catch (Exception e) {
            LOG.error("Failed to send notifications", e);
        }
    }
}
