package ru.yandex.intranet.d.services.transfer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.model.transfers.TransferResponsible;
import ru.yandex.intranet.d.model.transfers.TransferVote;
import ru.yandex.intranet.d.model.transfers.TransferVotes;
import ru.yandex.intranet.d.model.transfers.VoteType;

/**
 * TransferRequestVoteService.
 * TODO: Можно перенести в этот сервис больше логики связанной с голосованием.
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 */
@Component
public class TransferRequestVoteService {

    /**
     * Проверяет, что pending заявка не сможет подтвердиться.
     * То есть со всех сторон, с которых ещё ожидается подтверждение, все оставшиеся ответсвенные воздержались.
     * Кроме уже существующих голосов можно передать "добавочные" воздержания, например, от текущего юзера.
     * Reject голоса не поддерживаются. Заявка должна находиться не в статусе pending если обладает таким голосом.
     *
     * @param additionalAbstains дополнительный набор id воздержавшихся юзеров
     */
    public boolean pendingTransferRequestUnableToConfirm(TransferResponsible transferResponsible,
                                                         TransferVotes votes,
                                                         Set<String> additionalAbstains) {
        Map<String, Map<String, TransferVote>> votesByFolderUser = new HashMap<>();
        votes.getVotes().forEach(vote -> vote.getFolderIds().forEach(folderId ->
                votesByFolderUser.computeIfAbsent(folderId, k -> new HashMap<>()).put(vote.getUserId(), vote)));

        return unableToConfirmForService(transferResponsible, additionalAbstains, votesByFolderUser) ||
                unableToConfirmForReserveFolder(transferResponsible, additionalAbstains, votesByFolderUser);
    }

    private boolean unableToConfirmForService(TransferResponsible transferResponsible,
                                              Set<String> additionalAbstains,
                                              Map<String, Map<String, TransferVote>> votesByFolderUser) {
        return transferResponsible.getResponsible().stream().anyMatch(foldersResponsible ->
                foldersResponsible.getFolderIds().stream().anyMatch(folderId -> {
                    Map<String, TransferVote> folderVotesByUser = votesByFolderUser
                            .getOrDefault(folderId, Collections.emptyMap());
                    return foldersResponsible.getResponsible().stream().allMatch(responsible ->
                            responsible.getResponsibleIds().stream().allMatch(responsibleId -> {
                                TransferVote responsibleVote = folderVotesByUser.get(responsibleId);
                                return additionalAbstains.contains(responsibleId)
                                        || (responsibleVote != null && VoteType.ABSTAIN.equals(responsibleVote.getType()
                                ));
                            }));
                }));
    }

    private boolean unableToConfirmForReserveFolder(TransferResponsible transferResponsible,
                                                    Set<String> additionalAbstains,
                                                    Map<String, Map<String, TransferVote>> votesByFolderUser) {
        return transferResponsible.getReserveResponsibleModel().map(reserveResponsible -> {
            var votesByUser = votesByFolderUser.getOrDefault(reserveResponsible.getFolderId(),
                    Collections.emptyMap());

            return reserveResponsible.getResponsibleIds().stream().allMatch(responsibleId -> {
                TransferVote transferVote = votesByUser.get(responsibleId);
                return additionalAbstains.contains(responsibleId)
                        || (transferVote != null && VoteType.ABSTAIN.equals(transferVote.getType()));
            });
        }).orElse(false);
    }

}
