package ru.yandex.intranet.d.services.transfer.model;

import java.util.Objects;

import com.google.common.base.Preconditions;

import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Create transfer request confirmation data.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateTransferRequestConfirmationData {

    private final boolean confirm;
    private final boolean apply;
    private final UserModel user;
    private final boolean providerResponsibleAutoConfirm;

    public CreateTransferRequestConfirmationData(boolean confirm, boolean apply, UserModel user,
                                                 boolean providerResponsibleAutoConfirm) {
        this.confirm = confirm;
        this.apply = apply;
        this.user = user;
        this.providerResponsibleAutoConfirm = providerResponsibleAutoConfirm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isConfirm() {
        return confirm;
    }

    public boolean isApply() {
        return apply;
    }

    public UserModel getUser() {
        return user;
    }

    public boolean isProviderResponsibleAutoConfirm() {
        return providerResponsibleAutoConfirm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateTransferRequestConfirmationData that = (CreateTransferRequestConfirmationData) o;
        return confirm == that.confirm &&
                apply == that.apply &&
                providerResponsibleAutoConfirm == that.providerResponsibleAutoConfirm &&
                Objects.equals(user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(confirm, apply, user, providerResponsibleAutoConfirm);
    }

    @Override
    public String toString() {
        return "CreateTransferRequestConfirmationData{" +
                "confirm=" + confirm +
                ", apply=" + apply +
                ", user=" + user +
                ", providerResponsibleAutoConfirm=" + providerResponsibleAutoConfirm +
                '}';
    }

    public static final class Builder {

        private Boolean confirm;
        private Boolean apply;
        private UserModel user;
        private Boolean providerResponsibleAutoConfirm;

        private Builder() {
        }

        public Builder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        public Builder apply(boolean apply) {
            this.apply = apply;
            return this;
        }

        public Builder user(UserModel user) {
            this.user = user;
            return this;
        }

        public Builder providerResponsibleAutoConfirm(boolean providerResponsibleAutoConfirm) {
            this.providerResponsibleAutoConfirm = providerResponsibleAutoConfirm;
            return this;
        }

        public CreateTransferRequestConfirmationData build() {
            Preconditions.checkNotNull(confirm, "Confirm is required");
            Preconditions.checkNotNull(apply, "Apply is required");
            Preconditions.checkNotNull(user, "User is required");
            Preconditions.checkNotNull(providerResponsibleAutoConfirm, "ProviderResponsibleAutoConfirm is required");
            return new CreateTransferRequestConfirmationData(confirm, apply, user, providerResponsibleAutoConfirm);
        }

    }

}
