package ru.yandex.intranet.d.services.transfer.model

import ru.yandex.intranet.d.kotlin.LoanId
import java.time.LocalDate

/**
 * Pre validated loan parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class PreValidatedLoanParameters(
    val borrowParameters: PreValidatedLoanBorrowParameters?,
    val payOffParameters: PreValidatedLoanPayOffParameters?,
    val provideOverCommitReserve: Boolean?,
)

data class PreValidatedLoanBorrowParameters(
    val dueDate: LocalDate
)

data class PreValidatedLoanPayOffParameters(
    val loanId: LoanId
)
