package ru.yandex.intranet.d.services.transfer.model;

import java.math.BigDecimal;
import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Pre validated quota resource transfer.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class PreValidatedQuotaResourceTransfer {

    private final String resourceId;
    private final BigDecimal delta;
    private final String deltaUnitId;
    private final long index;

    public PreValidatedQuotaResourceTransfer(String resourceId, BigDecimal delta, String deltaUnitId, long index) {
        this.resourceId = resourceId;
        this.delta = delta;
        this.deltaUnitId = deltaUnitId;
        this.index = index;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResourceId() {
        return resourceId;
    }

    public BigDecimal getDelta() {
        return delta;
    }

    public String getDeltaUnitId() {
        return deltaUnitId;
    }

    public long getIndex() {
        return index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreValidatedQuotaResourceTransfer that = (PreValidatedQuotaResourceTransfer) o;
        return index == that.index && Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(delta, that.delta) &&
                Objects.equals(deltaUnitId, that.deltaUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, delta, deltaUnitId, index);
    }

    @Override
    public String toString() {
        return "PreValidatedQuotaResourceTransfer{" +
                "resourceId='" + resourceId + '\'' +
                ", delta=" + delta +
                ", deltaUnitId='" + deltaUnitId + '\'' +
                ", index=" + index +
                '}';
    }

    public static final class Builder {

        private String resourceId;
        private BigDecimal delta;
        private String deltaUnitId;
        private Long index;

        private Builder() {
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder delta(BigDecimal delta) {
            this.delta = delta;
            return this;
        }

        public Builder deltaUnitId(String deltaUnitId) {
            this.deltaUnitId = deltaUnitId;
            return this;
        }

        public Builder index(long index) {
            this.index = index;
            return this;
        }

        public PreValidatedQuotaResourceTransfer build() {
            Preconditions.checkNotNull(resourceId, "ResourceId is required");
            Preconditions.checkNotNull(delta, "Delta is required");
            Preconditions.checkNotNull(deltaUnitId, "DeltaUnitId is required");
            Preconditions.checkNotNull(index, "Index is required");
            return new PreValidatedQuotaResourceTransfer(resourceId, delta, deltaUnitId, index);
        }

    }

}
