package ru.yandex.intranet.d.services.transfer.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Pre validated quota transfer parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class PreValidatedQuotaTransferParameters {

    private final List<PreValidatedQuotaTransfer> transfers;

    public PreValidatedQuotaTransferParameters(List<PreValidatedQuotaTransfer> transfers) {
        this.transfers = transfers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<PreValidatedQuotaTransfer> getTransfers() {
        return transfers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreValidatedQuotaTransferParameters that = (PreValidatedQuotaTransferParameters) o;
        return Objects.equals(transfers, that.transfers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(transfers);
    }

    @Override
    public String toString() {
        return "PreValidatedQuotaTransferParameters{" +
                "transfers=" + transfers +
                '}';
    }

    public static final class Builder {

        private final List<PreValidatedQuotaTransfer> transfers = new ArrayList<>();

        private Builder() {
        }

        public Builder addTransfer(PreValidatedQuotaTransfer transfer) {
            transfers.add(transfer);
            return this;
        }

        public List<PreValidatedQuotaTransfer> getTransfers() {
            return transfers;
        }

        public PreValidatedQuotaTransferParameters build() {
            return new PreValidatedQuotaTransferParameters(transfers);
        }

    }

}
