package ru.yandex.intranet.d.services.transfer.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Pre validated transfer request parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class PreValidatedTransferRequestParameters {

    private final String description;

    public PreValidatedTransferRequestParameters(String description) {
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreValidatedTransferRequestParameters that = (PreValidatedTransferRequestParameters) o;
        return Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(description);
    }

    @Override
    public String toString() {
        return "PreValidatedTransferRequestParameters{" +
                "description='" + description + '\'' +
                '}';
    }

    public static final class Builder {

        private String description;

        private Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public PreValidatedTransferRequestParameters build() {
            return new PreValidatedTransferRequestParameters(description);
        }

    }

}
