package ru.yandex.intranet.d.services.transfer.model;

import java.util.Objects;

import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Put transfer request confirmation data.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class PutTransferRequestConfirmationData {

    private final boolean confirm;
    private final UserModel user;

    public PutTransferRequestConfirmationData(boolean confirm, UserModel user) {
        this.confirm = confirm;
        this.user = user;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isConfirm() {
        return confirm;
    }

    public UserModel getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PutTransferRequestConfirmationData that = (PutTransferRequestConfirmationData) o;
        return confirm == that.confirm &&
                Objects.equals(user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(confirm, user);
    }

    @Override
    public String toString() {
        return "PutTransferRequestConfirmationData{" +
                "confirm=" + confirm +
                ", user=" + user +
                '}';
    }

    public static final class Builder {

        private Boolean confirm;
        private UserModel user;

        private Builder() {
        }

        public Builder confirm(boolean confirm) {
            this.confirm = confirm;
            return this;
        }

        public Builder user(UserModel user) {
            this.user = user;
            return this;
        }

        public PutTransferRequestConfirmationData build() {
            return new PutTransferRequestConfirmationData(confirm, user);
        }

    }

}
