package ru.yandex.intranet.d.services.transfer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Transfer request continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class QuotaTransferPreApplicationData {

    private final List<QuotaModel> quotas;

    public QuotaTransferPreApplicationData(List<QuotaModel> quotas) {
        this.quotas = quotas;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<QuotaModel> getQuotas() {
        return quotas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaTransferPreApplicationData that = (QuotaTransferPreApplicationData) o;
        return Objects.equals(quotas, that.quotas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotas);
    }

    @Override
    public String toString() {
        return "QuotaTransferPreApplicationData{" +
                "quotas=" + quotas +
                '}';
    }

    public static final class Builder {

        private final List<QuotaModel> quotas = new ArrayList<>();

        private Builder() {
        }

        public Builder addQuota(QuotaModel quota) {
            this.quotas.add(quota);
            return this;
        }

        public Builder addQuotas(Collection<? extends QuotaModel> quotas) {
            this.quotas.addAll(quotas);
            return this;
        }

        public QuotaTransferPreApplicationData build() {
            return new QuotaTransferPreApplicationData(quotas);
        }

    }

}
