package ru.yandex.intranet.d.services.transfer.model;

import java.util.Objects;
import java.util.Set;

import com.google.common.base.Preconditions;

import ru.yandex.intranet.d.model.transfers.TransferRequestHistoryModel;
import ru.yandex.intranet.d.model.transfers.TransferRequestModel;
import ru.yandex.intranet.d.model.users.UserModel;

/**
 * RefreshTransferRequest.
 * Модель для обновления заявок в фоне.
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 * @see ru.yandex.intranet.d.tms.jobs.RefreshTransferRequests
 */
public final class RefreshTransferRequest {

    private final TransferRequestModel refreshedTransferRequest;
    private final TransferRequestIndices.Difference indicesDifference;
    private final TransferRequestHistoryModel history;
    private final Set<UserModel> notifiedUsers;

    @SuppressWarnings("ParameterNumber")
    public RefreshTransferRequest(TransferRequestModel refreshedTransferRequest,
                                  TransferRequestIndices.Difference indicesDifference,
                                  TransferRequestHistoryModel history,
                                  Set<UserModel> notifiedUsers) {
        this.refreshedTransferRequest = refreshedTransferRequest;
        this.indicesDifference = indicesDifference;
        this.history = history;
        this.notifiedUsers = notifiedUsers;
    }

    public TransferRequestModel getRefreshedTransferRequest() {
        return refreshedTransferRequest;
    }

    public TransferRequestIndices.Difference getIndicesDifference() {
        return indicesDifference;
    }

    public TransferRequestHistoryModel getHistory() {
        return history;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<UserModel> getNotifiedUsers() {
        return notifiedUsers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RefreshTransferRequest that = (RefreshTransferRequest) o;
        return refreshedTransferRequest.equals(that.refreshedTransferRequest) &&
                indicesDifference.equals(that.indicesDifference) &&
                history.equals(that.history) &&
                notifiedUsers.equals(that.notifiedUsers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(refreshedTransferRequest, indicesDifference, history, notifiedUsers);
    }

    @Override
    public String toString() {
        return "RefreshTransferRequest{" +
                "refreshedTransferRequest=" + refreshedTransferRequest +
                "indicesDifference=" + indicesDifference +
                "history=" + history +
                '}';
    }

    public static final class Builder {

        private TransferRequestModel refreshedTransferRequest;
        private TransferRequestIndices.Difference indicesDifference;
        private TransferRequestHistoryModel history;
        private Set<UserModel> notifiedUsers;

        private Builder() {
        }

        public Builder refreshedTransferRequest(TransferRequestModel refreshedTransferRequest) {
            this.refreshedTransferRequest = refreshedTransferRequest;
            return this;
        }

        public Builder indicesDifference(TransferRequestIndices.Difference indicesDifference) {
            this.indicesDifference = indicesDifference;
            return this;
        }

        public Builder history(TransferRequestHistoryModel history) {
            this.history = history;
            return this;
        }

        public Builder notified(Set<UserModel> notifiedUsers) {
            this.notifiedUsers = notifiedUsers;
            return this;
        }

        public RefreshTransferRequest build() {
            Preconditions.checkNotNull(refreshedTransferRequest,
                    "RefreshedTransferRequest is required");
            Preconditions.checkNotNull(indicesDifference,
                    "IndicesDifference is required");
            Preconditions.checkNotNull(notifiedUsers,
                    "NotifiedUsers is required");
            return new RefreshTransferRequest(refreshedTransferRequest,
                    indicesDifference,
                    history,
                    notifiedUsers);
        }
    }
}
