package ru.yandex.intranet.d.services.transfer.model;

import java.util.Objects;
import java.util.Set;

import ru.yandex.intranet.d.model.transfers.TransferResponsible;
import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Transfer request responsible and users to receive notifications.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ResponsibleAndNotified {

    private final TransferResponsible responsible;
    private final Set<UserModel> notifiedUsers;
    private final boolean providerResponsibleAutoConfirm;

    public ResponsibleAndNotified(TransferResponsible responsible, Set<UserModel> notifiedUsers,
                                  boolean providerResponsibleAutoConfirm) {
        this.responsible = responsible;
        this.notifiedUsers = notifiedUsers;
        this.providerResponsibleAutoConfirm = providerResponsibleAutoConfirm;
    }

    public TransferResponsible getResponsible() {
        return responsible;
    }

    public Set<UserModel> getNotifiedUsers() {
        return notifiedUsers;
    }

    public boolean isProviderResponsibleAutoConfirm() {
        return providerResponsibleAutoConfirm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResponsibleAndNotified that = (ResponsibleAndNotified) o;
        return Objects.equals(responsible, that.responsible) &&
                Objects.equals(notifiedUsers, that.notifiedUsers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(responsible, notifiedUsers);
    }

    @Override
    public String toString() {
        return "ResponsibleAndNotified{" +
                "responsible=" + responsible +
                ", notifiedUsers=" + notifiedUsers +
                '}';
    }

}
