package ru.yandex.intranet.d.services.transfer.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Transfer request history continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TransferRequestHistoryContinuationToken {

    private final String id;
    private final Long timestamp;

    @JsonCreator
    public TransferRequestHistoryContinuationToken(@JsonProperty("id") String id,
                                                   @JsonProperty("timestamp") Long timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public Optional<Long> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferRequestHistoryContinuationToken that = (TransferRequestHistoryContinuationToken) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(timestamp, that.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, timestamp);
    }

    @Override
    public String toString() {
        return "TransferRequestHistoryContinuationToken{" +
                "id='" + id + '\'' +
                ", timestamp=" + timestamp +
                '}';
    }

}
