package ru.yandex.intranet.d.services.transfer.model;

import java.util.Set;

import ru.yandex.intranet.d.model.transfers.TransferRequestModel;
import ru.yandex.intranet.d.model.users.UserModel;

public class TransferRequestRefreshResult<T> {
    private final T data;
    private final TransferRequestModel request;
    private final Set<UserModel> notifiedUsers;
    private final boolean refreshed;

    public TransferRequestRefreshResult(T data,
                                        TransferRequestModel request,
                                        Set<UserModel> notifiedUsers,
                                        boolean refreshed) {
        this.data = data;
        this.request = request;
        this.notifiedUsers = notifiedUsers;
        this.refreshed = refreshed;
    }

    public T getData() {
        return data;
    }

    public Set<UserModel> getNotifiedUsers() {
        return notifiedUsers;
    }

    public boolean isRefreshed() {
        return refreshed;
    }

    public TransferRequestModel getRequest() {
        return request;
    }

}
