package ru.yandex.intranet.d.services.transfer.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.web.model.transfers.TransferRequestStatusDto;
import ru.yandex.intranet.d.web.model.transfers.front.FrontTransferRequestSearchDto;

/**
 * Transfer requests search parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class TransferRequestsSearchParameters {

    private final Boolean filterByCurrentUser;
    private final String filterByFolderId;
    private final String filterByServiceId;
    private final List<TransferRequestStatusDto> filterByStatus;

    public TransferRequestsSearchParameters(Boolean filterByCurrentUser,
                                            String filterByFolderId,
                                            String filterByServiceId,
                                            List<TransferRequestStatusDto> filterByStatus) {
        this.filterByCurrentUser = filterByCurrentUser;
        this.filterByFolderId = filterByFolderId;
        this.filterByServiceId = filterByServiceId;
        this.filterByStatus = filterByStatus;
    }

    public TransferRequestsSearchParameters(FrontTransferRequestSearchDto searchRequestDto) {
        this(searchRequestDto.getFilterByCurrentUser().orElse(null),
                searchRequestDto.getFilterByFolderId().orElse(null),
                searchRequestDto.getFilterByServiceId().orElse(null),
                searchRequestDto.getFilterByStatus().orElse(null));
    }

    public Optional<Boolean> getFilterByCurrentUser() {
        return Optional.ofNullable(filterByCurrentUser);
    }

    public Optional<String> getFilterByFolderId() {
        return Optional.ofNullable(filterByFolderId);
    }

    public Optional<String> getFilterByServiceId() {
        return Optional.ofNullable(filterByServiceId);
    }

    public Optional<List<TransferRequestStatusDto>> getFilterByStatus() {
        return Optional.ofNullable(filterByStatus);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferRequestsSearchParameters that = (TransferRequestsSearchParameters) o;
        return Objects.equals(filterByCurrentUser, that.filterByCurrentUser) &&
                Objects.equals(filterByFolderId, that.filterByFolderId) &&
                Objects.equals(filterByServiceId, that.filterByServiceId) &&
                Objects.equals(filterByStatus, that.filterByStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(filterByCurrentUser, filterByFolderId, filterByServiceId, filterByStatus);
    }

    @Override
    public String toString() {
        return "TransferRequestsSearchParameters{" +
                "filterByCurrentUser=" + filterByCurrentUser +
                ", filterByFolderId='" + filterByFolderId + '\'' +
                ", filterByServiceId='" + filterByServiceId + '\'' +
                ", filterByStatus=" + filterByStatus +
                '}';
    }

}
