package ru.yandex.intranet.d.services.transfer.model

import com.google.common.base.Preconditions
import ru.yandex.intranet.d.model.accounts.AccountModel
import ru.yandex.intranet.d.model.folders.FolderModel
import ru.yandex.intranet.d.model.services.ServiceMinimalModel

data class ValidatedProvisionTransfer(
    val sourceAccount: AccountModel,
    val sourceFolder: FolderModel,
    val sourceService: ServiceMinimalModel,
    val destinationAccount: AccountModel,
    val destinationFolder: FolderModel,
    val destinationService: ServiceMinimalModel,
    val sourceAccountTransfers: List<ValidatedQuotaResourceTransfer>,
    val destinationAccountTransfers: List<ValidatedQuotaResourceTransfer>,
) {
    companion object {
        @JvmStatic
        fun builder() = Builder()
    }

    data class Builder(
        var sourceAccount: AccountModel? = null,
        var sourceFolder: FolderModel? = null,
        var sourceService: ServiceMinimalModel? = null,
        var destinationAccount: AccountModel? = null,
        var destinationFolder: FolderModel? = null,
        var destinationService: ServiceMinimalModel? = null,
        val sourceAccountTransfers: MutableList<ValidatedQuotaResourceTransfer> = mutableListOf(),
        val destinationAccountTransfers: MutableList<ValidatedQuotaResourceTransfer> = mutableListOf(),
    ) {
        fun sourceAccount(sourceAccount: AccountModel) = apply {
            this.sourceAccount = sourceAccount
        }

        fun sourceFolder(sourceFolder: FolderModel) = apply {
            this.sourceFolder = sourceFolder
        }

        fun sourceService(sourceService: ServiceMinimalModel) = apply {
            this.sourceService = sourceService
        }

        fun destinationAccount(destinationAccount: AccountModel) = apply {
            this.destinationAccount = destinationAccount
        }

        fun destinationFolder(destinationFolder: FolderModel) = apply {
            this.destinationFolder = destinationFolder
        }

        fun destinationService(destinationService: ServiceMinimalModel) = apply {
            this.destinationService = destinationService
        }

        fun addSourceAccountTransfer(transfer: ValidatedQuotaResourceTransfer) = apply {
            this.sourceAccountTransfers += transfer
        }

        fun addDestinationAccountTransfer(transfer: ValidatedQuotaResourceTransfer) = apply {
            this.destinationAccountTransfers += transfer
        }

        fun build() = ValidatedProvisionTransfer(
            Preconditions.checkNotNull(sourceAccount, "SourceAccount is required"),
            Preconditions.checkNotNull(sourceFolder, "SourceFolder is required"),
            Preconditions.checkNotNull(sourceService, "SourceService is required"),
            Preconditions.checkNotNull(destinationAccount, "DestinationAccount is required"),
            Preconditions.checkNotNull(destinationFolder, "DestinationFolder is required"),
            Preconditions.checkNotNull(destinationService, "DestinationService is required"),
            sourceAccountTransfers, destinationAccountTransfers,
        )
    }
}
