package ru.yandex.intranet.d.services.transfer.model;

import java.time.Instant;
import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Validated transfer request continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidatedTransferRequestContinuationToken {

    private final String id;
    private final Instant createdAt;

    public ValidatedTransferRequestContinuationToken(String id, Instant createdAt) {
        this.id = id;
        this.createdAt = createdAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return id;
    }

    public Instant getCreatedAt() {
        return createdAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedTransferRequestContinuationToken that = (ValidatedTransferRequestContinuationToken) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(createdAt, that.createdAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, createdAt);
    }

    @Override
    public String toString() {
        return "ValidatedTransferRequestContinuationToken{" +
                "id='" + id + '\'' +
                ", createdAt=" + createdAt +
                '}';
    }

    public static final class Builder {

        private String id;
        private Instant createdAt;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ValidatedTransferRequestContinuationToken build() {
            Preconditions.checkNotNull(id, "Id is required");
            Preconditions.checkNotNull(createdAt, "CreatedAt is required");
            return new ValidatedTransferRequestContinuationToken(id, createdAt);
        }

    }

}
