package ru.yandex.intranet.d.services.transfer.model;

import java.time.Instant;
import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Validated transfer request history continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidatedTransferRequestHistoryContinuationToken {

    private final String id;
    private final Instant timestamp;

    public ValidatedTransferRequestHistoryContinuationToken(String id, Instant timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return id;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedTransferRequestHistoryContinuationToken that = (ValidatedTransferRequestHistoryContinuationToken) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(timestamp, that.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, timestamp);
    }

    @Override
    public String toString() {
        return "ValidatedTransferRequestHistoryContinuationToken{" +
                "id='" + id + '\'' +
                ", timestamp=" + timestamp +
                '}';
    }

    public static final class Builder {

        private String id;
        private Instant timestamp;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ValidatedTransferRequestHistoryContinuationToken build() {
            Preconditions.checkNotNull(id, "Id is required");
            Preconditions.checkNotNull(timestamp, "Timestamp is required");
            return new ValidatedTransferRequestHistoryContinuationToken(id, timestamp);
        }

    }

}
