package ru.yandex.intranet.d.services.transfer.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import ru.yandex.intranet.d.model.folders.FolderModel;
import ru.yandex.intranet.d.model.services.ServiceMinimalModel;
import ru.yandex.intranet.d.model.transfers.TransferRequestStatus;

/**
 * Validated transfer requests search parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidatedTransferRequestsSearchParameters {

    private final Boolean filterByCurrentUser;
    private final FolderModel filterByFolder;
    private final ServiceMinimalModel filterByService;
    private final Set<TransferRequestStatus> filterByStatus;

    public ValidatedTransferRequestsSearchParameters(Boolean filterByCurrentUser,
                                                     FolderModel filterByFolder,
                                                     ServiceMinimalModel filterByService,
                                                     Set<TransferRequestStatus> filterByStatus) {
        this.filterByCurrentUser = filterByCurrentUser;
        this.filterByFolder = filterByFolder;
        this.filterByService = filterByService;
        this.filterByStatus = filterByStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Boolean> getFilterByCurrentUser() {
        return Optional.ofNullable(filterByCurrentUser);
    }

    public Optional<FolderModel> getFilterByFolder() {
        return Optional.ofNullable(filterByFolder);
    }

    public Optional<ServiceMinimalModel> getFilterByService() {
        return Optional.ofNullable(filterByService);
    }

    public Set<TransferRequestStatus> getFilterByStatus() {
        return filterByStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedTransferRequestsSearchParameters that = (ValidatedTransferRequestsSearchParameters) o;
        return Objects.equals(filterByCurrentUser, that.filterByCurrentUser) &&
                Objects.equals(filterByFolder, that.filterByFolder) &&
                Objects.equals(filterByService, that.filterByService) &&
                Objects.equals(filterByStatus, that.filterByStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(filterByCurrentUser, filterByFolder, filterByService, filterByStatus);
    }

    @Override
    public String toString() {
        return "ValidatedTransferRequestsSearchParameters{" +
                "filterByCurrentUser=" + filterByCurrentUser +
                ", filterByFolder=" + filterByFolder +
                ", filterByService=" + filterByService +
                ", filterByStatus=" + filterByStatus +
                '}';
    }

    public static final class Builder {

        private final Set<TransferRequestStatus> filterByStatus = new HashSet<>();

        private Boolean filterByCurrentUser;
        private FolderModel filterByFolder;
        private ServiceMinimalModel filterByService;

        private Builder() {
        }

        public Builder filterByCurrentUser(boolean filterByCurrentUser) {
            this.filterByCurrentUser = filterByCurrentUser;
            return this;
        }

        public Builder filterByFolder(FolderModel filterByFolder) {
            this.filterByFolder = filterByFolder;
            return this;
        }

        public Builder filterByService(ServiceMinimalModel filterByService) {
            this.filterByService = filterByService;
            return this;
        }

        public Builder addFilterByStatus(TransferRequestStatus status) {
            this.filterByStatus.add(status);
            return this;
        }

        public ValidatedTransferRequestsSearchParameters build() {
            return new ValidatedTransferRequestsSearchParameters(filterByCurrentUser, filterByFolder, filterByService,
                    filterByStatus);
        }

    }

}
