package ru.yandex.intranet.d.services.transfer.model.dryrun;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * DryRunTransferRequestFolderWarnings
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public final class DryRunTransferRequestFolderWarnings {
    private final List<String> messages;
    private final Map<String, List<String>> perResource;
    private final Map<String, Map<String, Object>> detailsPerResource;

    public DryRunTransferRequestFolderWarnings(List<String> messages, Map<String, List<String>> perResource,
                                               Map<String, Map<String, Object>> detailsPerResource) {
        this.messages = messages;
        this.perResource = perResource;
        this.detailsPerResource = detailsPerResource;
    }

    public List<String> getMessages() {
        return messages;
    }

    public Map<String, List<String>> getPerResource() {
        return perResource;
    }

    public Map<String, Map<String, Object>> getDetailsPerResource() {
        return detailsPerResource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DryRunTransferRequestFolderWarnings that = (DryRunTransferRequestFolderWarnings) o;
        return Objects.equals(messages, that.messages) && Objects.equals(perResource, that.perResource)
                && Objects.equals(detailsPerResource, that.detailsPerResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(messages, perResource, detailsPerResource);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
