package ru.yandex.intranet.d.services.transfer.model.dryrun;

import java.util.Objects;

/**
 * DryRunTransferRequestPermissions
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public final class DryRunTransferRequestPermissions {
    private final boolean canVote;
    private final boolean canAutoConfirmAsProviderResponsible;
    private final boolean canConfirmSingleHandedly;

    public DryRunTransferRequestPermissions(boolean canVote, boolean canAutoConfirmAsProviderResponsible,
                                            boolean canConfirmSingleHandedly) {
        this.canVote = canVote;
        this.canAutoConfirmAsProviderResponsible = canAutoConfirmAsProviderResponsible;
        this.canConfirmSingleHandedly = canConfirmSingleHandedly;
    }

    public boolean isCanVote() {
        return canVote;
    }

    public boolean isCanAutoConfirmAsProviderResponsible() {
        return canAutoConfirmAsProviderResponsible;
    }

    public boolean isCanConfirmSingleHandedly() {
        return canConfirmSingleHandedly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DryRunTransferRequestPermissions that = (DryRunTransferRequestPermissions) o;
        return canVote == that.canVote &&
                canAutoConfirmAsProviderResponsible == that.canAutoConfirmAsProviderResponsible &&
                canConfirmSingleHandedly == that.canConfirmSingleHandedly;
    }

    @Override
    public int hashCode() {
        return Objects.hash(canVote, canAutoConfirmAsProviderResponsible, canConfirmSingleHandedly);
    }

    @Override
    public String toString() {
        return "DryRunTransferRequestPermissions{" +
                "canVote=" + canVote +
                ", canAutoConfirmAsProviderResponsible=" + canAutoConfirmAsProviderResponsible +
                ", canConfirmSingleHandedly=" + canConfirmSingleHandedly +
                '}';
    }
}
