package ru.yandex.intranet.d.services.transfer.model.dryrun;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * DryRunTransferRequestWarnings
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public final class DryRunTransferRequestWarnings {
    private final List<String> messages;
    private final Map<String, List<String>> perResource;
    private final Map<String, DryRunTransferRequestFolderWarnings> perFolder;
    private final Map<String, Map<String, Object>> detailsPerResource;
    private final Map<String, DryRunTransferRequestAccountWarnings> perAccount;

    public DryRunTransferRequestWarnings(List<String> messages, Map<String, List<String>> perResource,
                                         Map<String, DryRunTransferRequestFolderWarnings> perFolder,
                                         Map<String, Map<String, Object>> detailsPerResource,
                                         Map<String, DryRunTransferRequestAccountWarnings> perAccount) {
        this.messages = messages;
        this.perResource = perResource;
        this.perFolder = perFolder;
        this.detailsPerResource = detailsPerResource;
        this.perAccount = perAccount;
    }

    public List<String> getMessages() {
        return messages;
    }

    public Map<String, List<String>> getPerResource() {
        return perResource;
    }

    public Map<String, DryRunTransferRequestFolderWarnings> getPerFolder() {
        return perFolder;
    }

    public Map<String, Map<String, Object>> getDetailsPerResource() {
        return detailsPerResource;
    }

    public Map<String, DryRunTransferRequestAccountWarnings> getPerAccount() {
        return perAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DryRunTransferRequestWarnings that = (DryRunTransferRequestWarnings) o;
        return Objects.equals(messages, that.messages) && Objects.equals(perResource, that.perResource) &&
                Objects.equals(perFolder, that.perFolder) &&
                Objects.equals(perAccount, that.perAccount) &&
                Objects.equals(detailsPerResource, that.detailsPerResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(messages, perResource, perFolder, detailsPerResource, perAccount);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
