package ru.yandex.intranet.d.services.transfer.ticket;

/**
 * Transfer request type for tracker components
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public enum TrackerTransferType {
    TRANSFER("tracker.transfer.type.transfer"),
    RESERVE("tracker.transfer.type.reserve"),
    PROVISION("tracker.transfer.type.provision"),
    PREPAID("tracker.transfer.type.prepaid"),
    CREDIT("tracker.transfer.type.credit"),
    FREETIER("tracker.transfer.type.freetier"),
    EXCHANGE("tracker.transfer.type.exchange"),
    LOAN("tracker.transfer.type.loan");

    private final String componentEnvValue;

    TrackerTransferType(String componentEnvValue) {
        this.componentEnvValue = componentEnvValue;
    }

    public String getComponentEnvValue() {
        return componentEnvValue;
    }
}
