package ru.yandex.intranet.d.services.uniques

import ru.yandex.intranet.d.model.accounts.AccountModel
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel
import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel
import ru.yandex.intranet.d.model.resources.ResourceModel
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel

/**
 * Provide reserve operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ProvideReserveOperation(
    val result: ProvideReserveOperationResult?,
    val operation: AccountsQuotasOperationsModel
) {
    data class ProvideReserveOperationResult(
        val provisions: List<AccountsQuotasModel>,
        val resources: List<ResourceModel>,
        val unitsEnsembles: List<UnitsEnsembleModel>,
        val account: AccountModel
    )
}
