package ru.yandex.intranet.d.services.uniques

import ru.yandex.intranet.d.model.accounts.AccountModel
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel
import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel
import ru.yandex.intranet.d.model.folders.FolderModel
import ru.yandex.intranet.d.model.quotas.QuotaModel
import ru.yandex.intranet.d.model.resources.ResourceModel
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel

/**
 * Create account operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class UpdateProvisionOperation(val provisions: UpdatedProvisions?, val operation: AccountsQuotasOperationsModel,
                                    val folder: FolderModel) {

    data class UpdatedProvisions(val provisions: List<AccountsQuotasModel>,
                                 val resources: List<ResourceModel>,
                                 val unitsEnsembles: List<UnitsEnsembleModel>,
                                 val account: AccountModel,
                                 val folderQuotas: List<QuotaModel>,
                                 val folderAccounts: List<AccountModel>,
                                 val folderProvisions: List<AccountsQuotasModel>,
                                 val folderResources: List<ResourceModel>,
                                 val folderUnitsEnsembles: List<UnitsEnsembleModel>)
}
