package ru.yandex.intranet.d.services.units;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

import ru.yandex.intranet.d.model.units.UnitModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * Units comparator.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class UnitsComparator implements Comparator<UnitModel> {

    public static final UnitsComparator INSTANCE = new UnitsComparator();

    public static UnitModel getBaseUnit(UnitsEnsembleModel unitsEnsemble) {
        return unitsEnsemble.getUnits().stream().min(UnitsComparator.INSTANCE).get();
    }

    public static List<String> getSortedIds(Collection<String> sourceUnitIds, UnitsEnsembleModel unitsEnsembleModel) {
        List<String> unitIds = new ArrayList<>(sourceUnitIds);

        unitIds.sort(Comparator.comparing(id -> unitsEnsembleModel.unitById(id).orElse(null),
                Comparator.nullsLast(UnitsComparator.INSTANCE)));
        return unitIds;
    }

    @Override
    public int compare(UnitModel l, UnitModel r) {
        if (l.getBase() == r.getBase() && l.getPower() == r.getPower()) {
            return 0;
        }
        if (l.getPower() == 0 && r.getPower() == 0) {
            return 0;
        }
        if (l.getBase() == 1 && r.getBase() == 1) {
            return 0;
        }
        if (l.getPower() == 0 && r.getBase() == 1) {
            return 0;
        }
        if (l.getBase() == 1 && r.getPower() == 0) {
            return 0;
        }
        if (l.getPower() <= 0 && r.getPower() >= 0) {
            return -1;
        }
        if (l.getPower() >= 0 && r.getPower() <= 0) {
            return 1;
        }
        if (l.getPower() == r.getPower() && l.getPower() > 0) {
            return Long.compare(l.getBase(), r.getBase());
        }
        if (l.getPower() == r.getPower()) {
            return Long.compare(r.getBase(), l.getBase());
        }
        if (l.getBase() == r.getBase()) {
            return Long.compare(l.getPower(), r.getPower());
        }
        if (l.getPower() < 0 && r.getPower() < 0) {
            return BigDecimal.valueOf(r.getBase()).pow(Math.abs((int) r.getPower()))
                    .compareTo(BigDecimal.valueOf(l.getBase()).pow(Math.abs((int) l.getPower())));
        } else {
            return BigDecimal.valueOf(l.getBase()).pow((int) l.getPower())
                    .compareTo(BigDecimal.valueOf(r.getBase()).pow((int) r.getPower()));
        }
    }

}
