package ru.yandex.intranet.d.services.validators;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.util.result.ErrorCollection;
import ru.yandex.intranet.d.util.result.TypedError;

@Component
public class VersionValidator {
    protected final MessageSource messages;

    public VersionValidator(@Qualifier("messageSource") MessageSource messages) {
        this.messages = messages;
    }

    public void validate(
            Supplier<Optional<Long>> getter,
            Supplier<Long> existingGetter,
            Consumer<Long> setter,
            ErrorCollection.Builder errors,
            String fieldKey,
            Locale locale
    ) {
        Optional<Long> value = getter.get();
        Long existingValue = existingGetter.get();
        if (value.isEmpty()) {
            errors.addError(fieldKey, TypedError.invalid(messages
                    .getMessage("errors.field.is.required", null, locale)));
        } else if (!Objects.equals(value.get(), existingValue)) {
            errors.addError(fieldKey, TypedError.versionMismatch(messages
                    .getMessage("errors.version.mismatch", null, locale)));
        } else {
            setter.accept(existingValue + 1L);
        }
    }
}
