package ru.yandex.intranet.d.tms;

import java.time.temporal.ChronoUnit;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.direct.hourglass.HourglassProperties;

@Configuration
public class HourglassPropertiesConfiguration {
    @Bean
    @SuppressWarnings("ParameterNumber")
    public HourglassProperties hourglassProperties(
            @Value("${scheduler.taskFetchingIntervalMs}") long taskFetchingIntervalMs,
            @Value("${scheduler.reschedulingTasksIntervalSec}") long reschedulingTasksIntervalSec,
            @Value("${scheduler.maxHeartbeatAgeSec}") long maxHeartbeatAgeSec,
            @Value("${scheduler.pingIntervalMs}") long pingIntervalMs,
            @Value("${scheduler.jobsFreeingIntervalSec}") long jobsFreeingIntervalSec,
            @Value("${scheduler.instancePingIntervalMs}") long instancePingIntervalMs,
            @Value("${scheduler.scheduleUpdateIntervalMin}") long scheduleUpdateIntervalMin,
            @Value("${scheduler.scheduleHeartbeatExpirationMin}") long scheduleHeartbeatExpirationMin,
            @Value("${scheduler.missedTaskThresholdSec}") long missedTaskThresholdSec,
            @Value("${scheduler.threadPoolSize}") int threadPoolSize,
            @Value("${scheduler.leaderVotingLowerBound}") int leaderVotingLowerBound
    ) {
        return HourglassProperties.builder()
                .setTaskFetchingInterval(taskFetchingIntervalMs, ChronoUnit.MILLIS)
                .setReschedulingTasksInterval(reschedulingTasksIntervalSec, ChronoUnit.SECONDS)
                .setMaxHeartbeatAge(maxHeartbeatAgeSec, ChronoUnit.SECONDS)
                .setPingInterval(pingIntervalMs, ChronoUnit.MILLIS)
                .setJobsFreeingInterval(jobsFreeingIntervalSec, ChronoUnit.SECONDS)
                .setInstancePingInterval(instancePingIntervalMs, ChronoUnit.MILLIS)
                .setScheduleUpdateInterval(scheduleUpdateIntervalMin, ChronoUnit.MINUTES)
                .setScheduleHeartbeatExpiration(scheduleHeartbeatExpirationMin, ChronoUnit.MINUTES)
                .setMissedTaskThreshold(missedTaskThresholdSec, ChronoUnit.SECONDS)
                .setThreadPoolSize(threadPoolSize)
                .setLeaderVotingLowerBound(leaderVotingLowerBound)
                .build();
    }
}
