package ru.yandex.intranet.d.tms;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.direct.hourglass.HourglassProperties;
import ru.yandex.direct.hourglass.InstanceId;
import ru.yandex.direct.hourglass.storage.Storage;
import ru.yandex.direct.hourglass.updateschedule.SchedulerInstancesRepository;
import ru.yandex.direct.hourglass.ydb.schedulerinstances.YdbScheduleInstancesRepository;
import ru.yandex.direct.hourglass.ydb.storage.IdHashSha256Generator;
import ru.yandex.direct.hourglass.ydb.storage.YdbStorageImpl;
import ru.yandex.direct.ydb.YdbPath;
import ru.yandex.direct.ydb.client.YdbSessionProperties;
import ru.yandex.intranet.d.datasource.YdbConfiguration;

@Configuration
@Import({
        HourglassPropertiesConfiguration.class,
        YdbConfiguration.class
})
@Profile({"local", "dev", "load-testing", "testing", "production"})
public class HourglassYdbStorageConfiguration {
    public static final String HOURGLASS_YDB_SESSION_PROPERTIES_BEAN = "HourglassYdbSessionProperties";
    public static final String HOURGLASS_YDB_PATH_BEAN = "HourglassYdbPath";

    @Bean(HOURGLASS_YDB_PATH_BEAN)
    public YdbPath ydbPath(
            @Value("${ydb.tablePathPrefix}") String dbName
    ) {
        return YdbPath.of(dbName);
    }

    @Bean(HOURGLASS_YDB_SESSION_PROPERTIES_BEAN)
    public YdbSessionProperties ydbProperties(
            @Value("${ydb.queryRetries}") int maxQueryRetries,
            @Value("${ydb.retryNotFound}") boolean retryNotFound
    ) {
        return YdbSessionProperties.builder()
                .withMaxQueryRetries(maxQueryRetries)
                .withRetryNotFound(retryNotFound)
                .build();
    }

    @Bean
    public Storage ydbStorage(
            TableClient tableClient,
            @Qualifier(HOURGLASS_YDB_PATH_BEAN) YdbPath ydbPath,
            @Qualifier(HOURGLASS_YDB_SESSION_PROPERTIES_BEAN) YdbSessionProperties hourglassYdbProperties,
            HourglassProperties hourglassProperties,
            InstanceId instanceId,
            @Value("${scheduler.version}") String version
    ) {
        return new YdbStorageImpl(
                tableClient,
                ydbPath,
                hourglassYdbProperties,
                hourglassProperties,
                instanceId,
                version,
                new IdHashSha256Generator()
        );
    }

    @Bean
    public SchedulerInstancesRepository schedulerInstancesRepository(
            TableClient tableClient,
            @Qualifier(HOURGLASS_YDB_PATH_BEAN) YdbPath ydbPath,
            HourglassProperties hourglassProperties
    ) {
        return YdbScheduleInstancesRepository.builder(tableClient, ydbPath)
                .withHeartbeatExpiration(hourglassProperties.getSchedulerHeartbeatExpiration())
                .withLeaderVotingLowerBound(hourglassProperties.getLeaderVotingLowerBound())
                .build();
    }

//    @Bean
//    @Lazy(false)
//    public YdbSessionMonitoring sessionPoolStatsMonitoring(
//            MetricRegistry metricRegistry,
//            MonitoringWriter monitoringWriter,
//            ThreadsHierarchy threadsHierarchy,
//            @Qualifier(HOURGLASS_YDB_TABLE_CLIENT_BEAN) TableClient tableClient
//    ) {
//        return new YdbSessionMonitoring(metricRegistry, monitoringWriter, threadsHierarchy, tableClient);
//    }
}
