package ru.yandex.intranet.d.tms

import kotlinx.coroutines.reactor.awaitSingle
import kotlinx.coroutines.runBlocking
import org.springframework.stereotype.Component
import ru.yandex.direct.scheduler.support.ParametersSource
import ru.yandex.intranet.d.dao.Tenants
import ru.yandex.intranet.d.dao.providers.ProvidersDao
import ru.yandex.intranet.d.datasource.dbSessionRetryable
import ru.yandex.intranet.d.datasource.model.YdbTableClient

/**
 * Parameter source of cron job to refresh service aggregates.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
class RefreshServiceAggregatesParametersSource(
    private val tableClient: YdbTableClient,
    private val providersDao: ProvidersDao
): ParametersSource<String?> {

    override fun getAllParamValues(): MutableList<String> {
        return runBlocking {
            dbSessionRetryable(tableClient) {
                providersDao.getAllByTenant(roStaleSingleRetryableCommit(),
                    Tenants.DEFAULT_TENANT_ID, false).awaitSingle().get().map { it.id }.toMutableList()
            }!!
        }
    }

    override fun convertParamToString(paramValue: String?): String? {
        return paramValue
    }

    override fun convertStringToParam(string: String?): String? {
        return string
    }
}
