package ru.yandex.intranet.d.tms;

import java.util.List;
import java.util.stream.Collectors;

import com.yandex.ydb.table.transaction.TransactionMode;
import org.springframework.stereotype.Component;

import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.intranet.d.dao.Tenants;
import ru.yandex.intranet.d.dao.providers.ProvidersDao;
import ru.yandex.intranet.d.datasource.model.YdbTableClient;
import ru.yandex.intranet.d.model.providers.ProviderModel;

/**
 * SyncAccountsParametersSource.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 31-03-2021
 */
@Component
public class SyncAccountsParametersSource implements ParametersSource<String> {
    private final YdbTableClient tableClient;
    private final ProvidersDao providersDao;

    public SyncAccountsParametersSource(YdbTableClient tableClient, ProvidersDao providersDao) {
        this.tableClient = tableClient;
        this.providersDao = providersDao;
    }

    @Override
    public List<String> getAllParamValues() {
        return tableClient.usingSessionMonoRetryable(session ->
                session.usingTxMonoRetryable(TransactionMode.SERIALIZABLE_READ_WRITE, txSession ->
                        providersDao.getAllByTenant(txSession, Tenants.DEFAULT_TENANT_ID, false)
                                .map(r -> r.get().stream()
                                        .map(ProviderModel::getId)
                                        .collect(Collectors.toList())))
        ).block();
    }

    @Override
    public String convertParamToString(String paramValue) {
        return paramValue;
    }

    @Override
    public String convertStringToParam(String string) {
        return string;
    }
}
