package ru.yandex.intranet.d.tms.jobs;

import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.intranet.d.services.folders.FolderService;
import ru.yandex.intranet.d.util.OneShotStopWatch;

/**
 * Cron job to add missing default folders for services.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Hourglass(periodInSeconds = 1800)
public class AddDefaultFolders extends BaseDirectJob {

    private static final Logger LOG = LoggerFactory.getLogger(AddDefaultFolders.class);

    private final FolderService folderService;

    public AddDefaultFolders(FolderService folderService) {
        this.folderService = folderService;
    }

    @Override
    public void execute() {
        LOG.info("Adding missing default folders...");
        OneShotStopWatch stopWatch = new OneShotStopWatch();
        Long added = folderService.addDefaultFolders().block();
        LOG.info("Successfully finished adding {} missing default folders in {} seconds",
                added, stopWatch.elapsed(TimeUnit.SECONDS));
    }

}
