package ru.yandex.intranet.d.tms.jobs;

import java.time.Clock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.intranet.d.services.gc.QuotasProvisionsGCService;

/**
 * Cron job to GC zero quotas and provisions.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Hourglass(periodInSeconds = 3600)
public class QuotasProvisionsGCJob extends BaseDirectJob {

    private static final Logger LOG = LoggerFactory.getLogger(QuotasProvisionsGCJob.class);

    private final QuotasProvisionsGCService quotasProvisionsGCService;

    public QuotasProvisionsGCJob(QuotasProvisionsGCService quotasProvisionsGCService) {
        this.quotasProvisionsGCService = quotasProvisionsGCService;
    }

    @Override
    public void execute() {
        LOG.info("Running GC for quotas and provisions...");
        quotasProvisionsGCService.gcQuotasProvisions(Clock.systemUTC())
                .onErrorResume(e -> {
                    LOG.error("Failed to GC quotas and provisions", e);
                    return Mono.empty();
                })
                .block();
        LOG.info("GC for quotas and provisions finished");
    }
}
