package ru.yandex.intranet.d.tms.jobs

import kotlinx.coroutines.runBlocking
import mu.KotlinLogging
import org.springframework.beans.factory.annotation.Value
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.support.DirectParameterizedJob
import ru.yandex.direct.scheduler.support.ParameterizedBy
import ru.yandex.intranet.d.services.aggregates.RefreshServiceAggregatesService
import ru.yandex.intranet.d.tms.RefreshServiceAggregatesParametersSource
import java.time.Clock

private val logger = KotlinLogging.logger {}

/**
 * Cron job to refresh service aggregates.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Hourglass(periodInSeconds = 1800)
@ParameterizedBy(parametersSource = RefreshServiceAggregatesParametersSource::class)
class RefreshServiceAggregatesJob(
    private val refreshServiceAggregatesService: RefreshServiceAggregatesService,
    @Value("\${aggregation.background.enabled}") private val enabled: Boolean
): DirectParameterizedJob<String>() {

    override fun execute() {
        try {
            runBlocking {
                if (enabled) {
                    refreshServiceAggregatesService.refreshProvider(param, Clock.systemUTC())
                }
            }
        } catch (e: Exception) {
            logger.error(e) { "Failed to refresh service aggregates for $param" }
        }
    }

}
