package ru.yandex.intranet.d.tms.jobs;

import org.springframework.stereotype.Component;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.intranet.d.services.transfer.RefreshTransferRequestService;

/**
 * Cron job to refresh transfer requests.
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 * @see <a href="https://st.yandex-team.ru/DISPENSER-4357">DISPENSER-4357</a>
 */
@Hourglass(periodInSeconds = 300)
@Component
public class RefreshTransferRequests extends BaseDirectJob {

    private final RefreshTransferRequestService refreshTransferRequestService;

    @SuppressWarnings("checkstyle:ParameterNumber")
    public RefreshTransferRequests(RefreshTransferRequestService refreshTransferRequestService) {
        this.refreshTransferRequestService = refreshTransferRequestService;
    }

    @Override
    public void execute() {
        refreshTransferRequestService.refresh().block();
    }

}
