package ru.yandex.intranet.d.tms.jobs;

import java.time.Clock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.intranet.d.i18n.Locales;
import ru.yandex.intranet.d.services.operations.OperationsRetryService;

/**
 * Cron job to retry operations in providers.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Hourglass(periodInSeconds = 300)
public class RetryOperationsJob extends BaseDirectJob {

    private static final Logger LOG = LoggerFactory.getLogger(RetryOperationsJob.class);

    private final OperationsRetryService operationsRetryService;

    public RetryOperationsJob(OperationsRetryService operationsRetryService) {
        this.operationsRetryService = operationsRetryService;
    }

    @Override
    public void execute() {
        LOG.info("Running operations retry...");
        operationsRetryService.retryOperations(Clock.systemUTC(), Locales.ENGLISH).block();
        LOG.info("Operations retry finished");
    }

}
