package ru.yandex.intranet.d.tms.jobs

import io.github.resilience4j.core.IntervalFunction
import io.github.resilience4j.kotlin.retry.executeSuspendFunction
import io.github.resilience4j.retry.Retry
import kotlinx.coroutines.runBlocking
import mu.KotlinLogging
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.support.BaseDirectJob
import ru.yandex.intranet.d.services.usage.YpUsageSyncService
import ru.yandex.intranet.d.util.buildRetry
import java.time.Clock

private val logger = KotlinLogging.logger {}

/**
 * Cron job to sync YP usage.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Hourglass(cronExpression = "0 0 12 * * ?")
class SyncYpUsageJob(
    private val ypUsageSyncService: YpUsageSyncService
): BaseDirectJob() {

    private val retry: Retry = buildRetry("syncYpUsageJobRetry", 3,
        IntervalFunction.ofExponentialRandomBackoff(5000, 1.5, 0.5),
        { e: Throwable? -> e is Exception }, logger, "Sync YP usage job")

    override fun execute() {
        try {
            runBlocking {
                retry.executeSuspendFunction {
                    try {
                        ypUsageSyncService.doSync(Clock.systemUTC())
                    } catch (e: Exception) {
                        logger.error(e) { "Failed to sync YP usage" }
                        throw e
                    }
                }
            }
        } catch (e: Exception) {
            logger.error(e) { "Failed to sync YP usage" }
        }
    }

}
