package ru.yandex.intranet.d.tms.jobs

import io.github.resilience4j.core.IntervalFunction
import io.github.resilience4j.kotlin.retry.executeSuspendFunction
import io.github.resilience4j.retry.Retry
import kotlinx.coroutines.runBlocking
import mu.KotlinLogging
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.support.BaseDirectJob
import ru.yandex.intranet.d.services.usage.YtUsageSyncService
import ru.yandex.intranet.d.util.buildRetry
import java.time.Clock

private val logger = KotlinLogging.logger {}

/**
 * Cron job to sync YT usage.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Hourglass(cronExpression = "0 0 6 * * ?")
class SyncYtUsageJob(
    private val ytUsageSyncService: YtUsageSyncService
): BaseDirectJob() {

    private val retry: Retry = buildRetry("syncYtUsageJobRetry", 3,
        IntervalFunction.ofExponentialRandomBackoff(5000, 1.5, 0.5),
        { e: Throwable? -> e is Exception }, logger, "Sync YT usage job")

    override fun execute() {
        try {
            runBlocking {
                retry.executeSuspendFunction {
                    try {
                        ytUsageSyncService.doSync(Clock.systemUTC())
                    } catch (e: Exception) {
                        logger.error(e) { "Failed to sync YT usage" }
                        throw e
                    }
                }
            }
        } catch (e: Exception) {
            logger.error(e) { "Failed to sync YT usage" }
        }
    }
}
