package ru.yandex.intranet.d.util;

import javax.annotation.Nullable;

import ru.yandex.intranet.d.backend.service.proto.FreeProvisionAggregationMode;
import ru.yandex.intranet.d.web.model.providers.FreeProvisionAggregationModeDto;
import ru.yandex.intranet.d.web.model.providers.FreeProvisionAggregationModeInputDto;

/**
 * Aggregation mode helper.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AggregationModeHelper {

    private AggregationModeHelper() {
    }

    @Nullable
    public static FreeProvisionAggregationModeInputDto fromAggregationMode(
            @Nullable FreeProvisionAggregationMode mode) {
        if (mode == null) {
            return null;
        }
        return switch (mode) {
            case NONE -> FreeProvisionAggregationModeInputDto.NONE;
            case UNALLOCATED_TRANSFERABLE -> FreeProvisionAggregationModeInputDto.UNALLOCATED_TRANSFERABLE;
            case UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE -> FreeProvisionAggregationModeInputDto
                    .UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE;
            case UNDERUTILIZED_TRANSFERABLE -> FreeProvisionAggregationModeInputDto.UNDERUTILIZED_TRANSFERABLE;
            default -> FreeProvisionAggregationModeInputDto.UNKNOWN;
        };
    }

    public static FreeProvisionAggregationMode toAggregationMode(
            ru.yandex.intranet.d.model.providers.FreeProvisionAggregationMode mode) {
        return switch (mode) {
            case NONE -> FreeProvisionAggregationMode.NONE;
            case UNALLOCATED_TRANSFERABLE -> FreeProvisionAggregationMode.UNALLOCATED_TRANSFERABLE;
            case UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE -> FreeProvisionAggregationMode
                    .UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE;
            case UNDERUTILIZED_TRANSFERABLE -> FreeProvisionAggregationMode.UNDERUTILIZED_TRANSFERABLE;
        };
    }

    public static ru.yandex.intranet.d.model.providers.FreeProvisionAggregationMode toAggregationMode(
            FreeProvisionAggregationModeInputDto mode) {
        return switch (mode) {
            case NONE -> ru.yandex.intranet.d.model.providers.FreeProvisionAggregationMode.NONE;
            case UNALLOCATED_TRANSFERABLE -> ru.yandex.intranet.d.model.providers.FreeProvisionAggregationMode
                    .UNALLOCATED_TRANSFERABLE;
            case UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE -> ru.yandex.intranet.d.model.providers
                    .FreeProvisionAggregationMode.UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE;
            case UNDERUTILIZED_TRANSFERABLE -> ru.yandex.intranet.d.model.providers.FreeProvisionAggregationMode
                    .UNDERUTILIZED_TRANSFERABLE;
            default -> throw new IllegalArgumentException("Unexpected value " + mode);
        };
    }

    public static FreeProvisionAggregationModeDto toAggregationModeDto(
            ru.yandex.intranet.d.model.providers.FreeProvisionAggregationMode mode) {
        return switch (mode) {
            case NONE -> FreeProvisionAggregationModeDto.NONE;
            case UNALLOCATED_TRANSFERABLE -> FreeProvisionAggregationModeDto.UNALLOCATED_TRANSFERABLE;
            case UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE -> FreeProvisionAggregationModeDto
                    .UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE;
            case UNDERUTILIZED_TRANSFERABLE -> FreeProvisionAggregationModeDto.UNDERUTILIZED_TRANSFERABLE;
        };
    }

    public static FreeProvisionAggregationModeInputDto toAggregationModeInputDto(FreeProvisionAggregationModeDto mode) {
        return switch (mode) {
            case NONE -> FreeProvisionAggregationModeInputDto.NONE;
            case UNALLOCATED_TRANSFERABLE -> FreeProvisionAggregationModeInputDto.UNALLOCATED_TRANSFERABLE;
            case UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE -> FreeProvisionAggregationModeInputDto
                    .UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE;
            case UNDERUTILIZED_TRANSFERABLE -> FreeProvisionAggregationModeInputDto.UNDERUTILIZED_TRANSFERABLE;
        };
    }

}
