package ru.yandex.intranet.d.util;

import javax.annotation.Nullable;

import ru.yandex.intranet.d.backend.service.recipe_proto.AggregationQuotaQueryType;
import ru.yandex.intranet.d.web.model.providers.AggregationQuotaQueryTypeDto;
import ru.yandex.intranet.d.web.model.providers.AggregationQuotaQueryTypeInputDto;

/**
 * Aggregation quota query type helper.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AggregationQuotaQueryTypeHelper {

    private AggregationQuotaQueryTypeHelper() {
    }

    @Nullable
    public static AggregationQuotaQueryTypeInputDto fromAggregationQuotaQueryType(
            @Nullable AggregationQuotaQueryType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case PAGINATE -> AggregationQuotaQueryTypeInputDto.PAGINATE;
            case SCAN_SNAPSHOT -> AggregationQuotaQueryTypeInputDto.SCAN_SNAPSHOT;
            default -> AggregationQuotaQueryTypeInputDto.UNKNOWN;
        };
    }

    public static AggregationQuotaQueryType toAggregationQuotaQueryType(
            ru.yandex.intranet.d.model.providers.AggregationQuotaQueryType type) {
        return switch (type) {
            case PAGINATE -> AggregationQuotaQueryType.PAGINATE;
            case SCAN_SNAPSHOT -> AggregationQuotaQueryType.SCAN_SNAPSHOT;
        };
    }

    public static ru.yandex.intranet.d.model.providers.AggregationQuotaQueryType toAggregationQuotaQueryType(
            AggregationQuotaQueryTypeInputDto type) {
        return switch (type) {
            case PAGINATE -> ru.yandex.intranet.d.model.providers.AggregationQuotaQueryType.PAGINATE;
            case SCAN_SNAPSHOT -> ru.yandex.intranet.d.model.providers.AggregationQuotaQueryType.SCAN_SNAPSHOT;
            default -> throw new IllegalArgumentException("Unexpected value " + type);
        };
    }

    public static AggregationQuotaQueryTypeDto toAggregationQuotaQueryTypeDto(
            ru.yandex.intranet.d.model.providers.AggregationQuotaQueryType type) {
        return switch (type) {
            case PAGINATE -> AggregationQuotaQueryTypeDto.PAGINATE;
            case SCAN_SNAPSHOT -> AggregationQuotaQueryTypeDto.SCAN_SNAPSHOT;
        };
    }

    public static AggregationQuotaQueryTypeInputDto toAggregationQuotaQueryTypeInputDto(
            AggregationQuotaQueryTypeDto type) {
        return switch (type) {
            case PAGINATE -> AggregationQuotaQueryTypeInputDto.PAGINATE;
            case SCAN_SNAPSHOT -> AggregationQuotaQueryTypeInputDto.SCAN_SNAPSHOT;
        };
    }

}
