package ru.yandex.intranet.d.util;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Barrier.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class Barrier {

    private boolean open = true;
    private final Lock lock = new ReentrantLock();
    private final Condition openCondition = lock.newCondition();

    public void open() {
        lock.lock();
        try {
            open = true;
            openCondition.signalAll();
        } finally {
            lock.unlock();
        }
    }

    public void close() {
        lock.lock();
        try {
            open = false;
        } finally {
            lock.unlock();
        }
    }

    public void passThrough() throws InterruptedException {
        lock.lock();
        try {
            while (!open) {
                openCondition.await();
            }
        } finally {
            lock.unlock();
        }
    }

}
