package ru.yandex.intranet.d.util

import ru.yandex.intranet.d.model.accounts.AccountModel

object DisplayUtil {
    @JvmStatic
    fun getAccountDisplayString(accountModel: AccountModel): String {
        return with(accountModel) {
            displayName
                .orElse(outerAccountKeyInProvider
                    .orElse(outerAccountIdInProvider
                        .orElse(id)))
        }
    }

    @JvmStatic
    fun getAccountDisplayStringWithId(accountModel: AccountModel): String {
        val s = getAccountDisplayString(accountModel)
        return if (s == accountModel.id) {
            "'$s'"
        } else {
            "'$s' (${accountModel.id})"
        }
    }

    @JvmStatic
    fun String?.orElse(other: String): String {
        return if (this != null && this.isNotBlank()) {
            this
        } else {
            other
        }
    }
}
