package ru.yandex.intranet.d.util;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

import org.springframework.context.MessageSource;

import ru.yandex.intranet.d.backend.service.proto.FeatureState;
import ru.yandex.intranet.d.util.result.ErrorCollection;
import ru.yandex.intranet.d.util.result.TypedError;
import ru.yandex.intranet.d.web.model.FeatureStateInputDto;

/**
 * Feature state helper.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FeatureStateHelper {

    private FeatureStateHelper() {
    }

    public static void validateFeatureState(Supplier<Optional<FeatureStateInputDto>> getter, Consumer<Boolean> setter,
                                            ErrorCollection.Builder errors, String fieldKey, Locale locale,
                                            MessageSource messages) {
        Optional<FeatureStateInputDto> valueO = getter.get();
        if (valueO.isEmpty()) {
            setter.accept(null);
            return;
        }
        FeatureStateInputDto value = valueO.get();
        switch (value) {
            case UNSPECIFIED:
                setter.accept(null);
                break;
            case DISABLED:
                setter.accept(false);
                break;
            case ENABLED:
                setter.accept(true);
                break;
            default:
                errors.addError(fieldKey, TypedError.invalid(messages
                        .getMessage("errors.invalid.value", null, locale)));
        }
    }

    public static FeatureState toFeatureState(Boolean model) {
        if (model == null) {
            return FeatureState.UNSPECIFIED;
        }
        if (model) {
            return FeatureState.ENABLED;
        }
        return FeatureState.DISABLED;
    }

    public static FeatureStateInputDto fromFeatureState(FeatureState state) {
        switch (state) {
            case UNSPECIFIED:
                return FeatureStateInputDto.UNSPECIFIED;
            case DISABLED:
                return FeatureStateInputDto.DISABLED;
            case ENABLED:
                return FeatureStateInputDto.ENABLED;
            default:
                return FeatureStateInputDto.UNKNOWN;
        }
    }

}
