package ru.yandex.intranet.d.util;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;

import ru.yandex.direct.utils.io.RuntimeIoException;

/**
 * Typed adapter for ObjectReader.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @see com.fasterxml.jackson.databind.ObjectReader
 */
public class JsonReader<T> {
    private final ObjectReader continuationTokenReader;

    public JsonReader(ObjectMapper objectMapper, Class<T> clazz) {
        this.continuationTokenReader = objectMapper.readerFor(clazz);
    }

    public T readValue(byte[] content) {
        try {
            return continuationTokenReader.readValue(content);
        } catch (IOException e) {
            throw new RuntimeIoException(e);
        }
    }
}
