package ru.yandex.intranet.d.util

import com.fasterxml.jackson.core.type.TypeReference
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule
import com.fasterxml.jackson.module.kotlin.KotlinModule
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule

object JsonUtil {
    private val mapper = ObjectMapper()

    init {
        mapper.registerModule(Jdk8Module())
        mapper.registerModule(JavaTimeModule())
        mapper.registerModule(ParameterNamesModule())
        mapper.registerModule(KotlinModule.Builder().build())
    }

    @JvmStatic
    fun writeAsString(obj: Any): String = mapper.writeValueAsString(obj)

    @JvmStatic
    fun convertToMap(obj: Any): Map<String, Any> {
        return mapper.convertValue(obj, object : TypeReference<Map<String, Any>>() {})
    }
}
