package ru.yandex.intranet.d.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

import ru.yandex.direct.utils.io.RuntimeIoException;

/**
 * Typed adapter for ObjectWriter.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @see com.fasterxml.jackson.databind.ObjectWriter
 */
public class JsonWriter<T> {
    private final ObjectWriter continuationTokenWriter;

    public JsonWriter(ObjectMapper objectMapper, Class<T> clazz) {
        this.continuationTokenWriter = objectMapper.writerFor(clazz);
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return continuationTokenWriter.writeValueAsBytes(value);
        } catch (JsonProcessingException e) {
            throw new RuntimeIoException(e);
        }
    }
}
