package ru.yandex.intranet.d.util;

import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.NonNull;

/**
 * MDC log id task decorator.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class MdcTaskDecorator implements TaskDecorator {

    public static final String LOG_ID_MDC_KEY = "log_id";

    @NonNull
    @Override
    public Runnable decorate(@NonNull Runnable runnable) {
        String logId = MDC.get(LOG_ID_MDC_KEY);
        return () -> {
            if (logId != null) {
                MDC.put(LOG_ID_MDC_KEY, logId);
            }
            try {
                runnable.run();
            } finally {
                if (logId != null) {
                    MDC.remove(LOG_ID_MDC_KEY);
                }
            }
        };
    }
}
