package ru.yandex.intranet.d.util;

import java.util.Objects;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * Object mapper holder.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ObjectMapperHolder {

    private final ObjectMapper objectMapper;

    public ObjectMapperHolder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ObjectMapperHolder that = (ObjectMapperHolder) o;
        return Objects.equals(objectMapper, that.objectMapper);
    }

    @Override
    public int hashCode() {
        return Objects.hash(objectMapper);
    }

    @Override
    public String toString() {
        return "ObjectMapperHolder{" +
                "objectMapper=" + objectMapper +
                '}';
    }

}
