package ru.yandex.intranet.d.util;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;

/**
 * Resolver holder.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ResolverHolder {

    private static final int MAX_QUERIES_PER_RESOLVE = 3;
    private static final int MIN_TTL = 28800;
    private static final int MAX_TTL = Integer.MAX_VALUE;

    public static final AddressResolverGroup<?> RESOLVER_INSTANCE = prepareResolver();

    private ResolverHolder() {
    }

    private static AddressResolverGroup<?> prepareResolver() {
        DnsNameResolverBuilder dnsResolverBuilder = new DnsNameResolverBuilder();
        Class<? extends DatagramChannel> channelType = Epoll.isAvailable()
                ? EpollDatagramChannel.class : NioDatagramChannel.class;
        DnsServerAddressStreamProvider nameServerProvider = DnsServerAddressStreamProviders.platformDefault();
        dnsResolverBuilder
                .channelType(channelType)
                .nameServerProvider(nameServerProvider)
                .maxQueriesPerResolve(MAX_QUERIES_PER_RESOLVE)
                .ttl(MIN_TTL, MAX_TTL);
        return new RoundRobinDnsAddressResolverGroup(dnsResolverBuilder);
    }

}
