package ru.yandex.intranet.d.util

import io.github.resilience4j.core.IntervalFunction
import io.github.resilience4j.retry.Retry
import io.github.resilience4j.retry.RetryConfig
import mu.KLogger
import java.util.function.Predicate

fun buildRetry(key: String,
               maxAttempts: Int,
               intervalFunction: IntervalFunction,
               retryOnException: Predicate<Throwable>,
               logger: KLogger,
               logPrefix: String): Retry {
    val retry = Retry.of(key, RetryConfig.custom<Any>()
        .maxAttempts(maxAttempts)
        .intervalFunction(intervalFunction)
        .retryOnException(retryOnException)
        .build())
    retry.eventPublisher
        .onRetry { e ->
            if (e.lastThrowable != null) {
                logger.warn(e.lastThrowable) { "$logPrefix retry: $e" }
            } else {
                logger.warn { "$logPrefix retry: $e" }
            }
        }
        .onError { e ->
            if (e.lastThrowable != null) {
                logger.warn(e.lastThrowable) { "$logPrefix error: $e" }
            } else {
                logger.warn { "$logPrefix error: $e" }
            }
        }
        .onIgnoredError { e ->
            if (e.lastThrowable != null) {
                logger.warn(e.lastThrowable) { "$logPrefix ignored error: $e" }
            } else {
                logger.warn { "$logPrefix ignored error: $e" }
            }
        }
    return retry
}
